/*******************************************************************************
 System Interrupts File

  Company:
    Microchip Technology Inc.

  File Name:
    interrupt.c

  Summary:
    Interrupt vectors mapping

  Description:
    This file maps all the interrupt vectors to their corresponding
    implementations. If a particular module interrupt is used, then its ISR
    definition can be found in corresponding PLIB source file. If a module
    interrupt is not used, then its ISR implementation is mapped to dummy
    handler.
 *******************************************************************************/

// DOM-IGNORE-BEGIN
/*******************************************************************************
* Copyright (C) 2018 Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *******************************************************************************/
// DOM-IGNORE-END

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "configuration.h"
#include "interrupts.h"
#include "definitions.h"
#include "app.h"
#include "../../UTLN_Communication.h"


// *****************************************************************************
// *****************************************************************************
// Section: System Interrupt Vector Functions
// *****************************************************************************
// *****************************************************************************


void CORE_TIMER_InterruptHandler( void );
void TIMER_2_InterruptHandler( void );
void TIMER_5_InterruptHandler( void );
void UART1_FAULT_InterruptHandler( void );
void UART1_RX_InterruptHandler( void );
void UART1_TX_InterruptHandler( void );
void CHANGE_NOTICE_J_InterruptHandler( void );
void DRV_USBHS_InterruptHandler( void );
void DRV_USBHS_DMAInterruptHandler( void );
void DMA0_InterruptHandler( void );
void DMA1_InterruptHandler( void );
void DMA2_InterruptHandler( void );
void DMA3_InterruptHandler( void );
void DMA4_InterruptHandler( void );
void DMA5_InterruptHandler( void );
void DMA6_InterruptHandler( void );
void DMA7_InterruptHandler( void );
void SDHC_InterruptHandler( void );



/* All the handlers are defined here.  Each will call its PLIB-specific function. */
void CORE_TIMER_Handler (void)
{
    IO_13_Set();
    CORE_TIMER_InterruptHandler();
    IO_13_Clear();
}



void TIMER_2_Handler (void)
{
    TIMER_2_InterruptHandler();
}

void TIMER_5_Handler (void)
{
    TIMER_5_InterruptHandler();
}

void SPI1_FAULT_Handler (void)
{

    IFS3CLR= _IFS3_SPI1EIF_MASK;
    SPI1STATCLR = (1<<6);
    IO_14_Toggle();
}

void UART1_FAULT_Handler (void)
{
    UART1_FAULT_InterruptHandler();
}

void UART1_RX_Handler (void)
{
    UART1_RX_InterruptHandler();
}

void UART1_TX_Handler (void)
{
    //UART1_TX_InterruptHandler();
    
    if(UART3IsTransmissionActive())
    {
        //On renvoie un nouveau caract?re
        UART3WriteFromTxBuffer();

                /* Clear UART1TX Interrupt flag */
            IFS3CLR = _IFS3_U1TXIF_MASK;
        if(!UART3IsDataReadyInTxBuffer())
        {
            UART3ClearTransmissionActive();
            /* Disable the transmit interrupt, to avoid calling ISR continuously */
            IEC3CLR = _IEC3_U1TXIE_MASK;
        }
    }
    else
    {
        if(!UART3IsDataReadyInTxBuffer())
        {
            /* Disable the transmit interrupt, to avoid calling ISR continuously */
            IEC3CLR = _IEC3_U1TXIE_MASK;
        }
    }
}

void CHANGE_NOTICE_J_Handler (void)
{
    CHANGE_NOTICE_J_InterruptHandler();
}

void USB_Handler (void)
{
    IO_17_Set();
    DRV_USBHS_InterruptHandler();
    IO_17_Clear();
}

void USB_DMA_Handler (void)
{
    DRV_USBHS_DMAInterruptHandler();
}

void DMA0_Handler (void)
{

    //DMA0_InterruptHandler();
    IFS4CLR = 0x40;
    USTV_DMAC_CHANNEL0_CallBack();

}

void DMA1_Handler (void)
{

    //DMA1_InterruptHandler();
    IFS4CLR = 0x80;
    USTV_DMAC_CHANNEL1_CallBack();

}

void DMA2_Handler (void)
{

    //DMA2_InterruptHandler();
    IFS4CLR = 0x100;
    USTV_DMAC_CHANNEL2_CallBack();

}

void DMA3_Handler (void)
{
    /* Clear the interrupt flag and call event handler */
    IFS4CLR = 0x200;
    USTV_DMAC_CHANNEL3_CallBack();
    //DMA3_InterruptHandler();
}

void DMA4_Handler (void)
{
    /* Clear the interrupt flag and call event handler */
    IFS4CLR = 0x400;
    USTV_DMAC_CHANNEL4_CallBack();
    //DMA4_InterruptHandler();
}

void DMA5_Handler (void)
{
    /* Clear the interrupt flag and call event handler */
    IFS4CLR = 0x800;
    USTV_DMAC_CHANNEL5_CallBack();
    //DMA5_InterruptHandler();
}

void DMA6_Handler (void)
{
    //IO_0_Clear();
    IFS4CLR = 0x1000;
    USTV_DMAC_CHANNEL6_CallBack();
    //DMA6_InterruptHandler();
}

void DMA7_Handler (void)
{
    DMA7_InterruptHandler();
}

void SPI2_FAULT_Handler (void)
{
//    IFS4bits.SPI2EIF=0;
    IFS4CLR= _IFS4_SPI2EIF_MASK;
    SPI2STATCLR = (1<<6);
//    SPI2STATbits.SPIROV=0;
    IO_14_Toggle();
}

void SPI3_FAULT_Handler (void)
{
    IFS4bits.SPI3EIF=0;
    SPI3STATbits.SPIROV=0;
    IO_14_Toggle();
}

void UART3_FAULT_Handler (void)
{
}
    
void SPI4_FAULT_Handler (void)
{
    IFS5bits.SPI4EIF=0;
    SPI4STATbits.SPIROV=0;
    IO_14_Toggle();
}

void SDHC_Handler (void)
{
    //IO_14_Toggle();
    SDHC_InterruptHandler();
}





/*******************************************************************************
 End of File
*/
