/*******************************************************************************
  System Interrupts File

  Company:
    Microchip Technology Inc.

  File Name:
    interrupt_a.S

  Summary:
    Raw ISR definitions.

  Description:
    This file maps all the interrupt vectors to their corresponding
    implementations. If a particular module interrupt is used, then its ISR
    definition can be found in corresponding PLIB source file. If a module
    interrupt is not used, then its ISR implementation is mapped to dummy
    handler.
 *******************************************************************************/

// DOM-IGNORE-BEGIN
/*******************************************************************************
* Copyright (C) 2019 Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *******************************************************************************/
// DOM-IGNORE-END

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <xc.h>
#include "ISR_Support.h"

    .extern  CORE_TIMER_Handler

    .section   .vector_0,code, keep
    .equ     __vector_dispatch_0, IntVectorCORE_TIMER_Handler
    .global  __vector_dispatch_0
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorCORE_TIMER_Handler

IntVectorCORE_TIMER_Handler:
    portSAVE_CONTEXT
    la    s6,  CORE_TIMER_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorCORE_TIMER_Handler
    .extern  TIMER_2_Handler

    .section   .vector_9,code, keep
    .equ     __vector_dispatch_9, IntVectorTIMER_2_Handler
    .global  __vector_dispatch_9
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorTIMER_2_Handler

IntVectorTIMER_2_Handler:
    portSAVE_CONTEXT
    la    s6,  TIMER_2_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorTIMER_2_Handler
    .extern  TIMER_5_Handler

    .section   .vector_24,code, keep
    .equ     __vector_dispatch_24, IntVectorTIMER_5_Handler
    .global  __vector_dispatch_24
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorTIMER_5_Handler

IntVectorTIMER_5_Handler:
    portSAVE_CONTEXT
    la    s6,  TIMER_5_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorTIMER_5_Handler
    .extern  SPI1_FAULT_Handler

    .section   .vector_109,code, keep
    .equ     __vector_dispatch_109, IntVectorSPI1_FAULT_Handler
    .global  __vector_dispatch_109
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorSPI1_FAULT_Handler

IntVectorSPI1_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  SPI1_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorSPI1_FAULT_Handler
    .extern  UART1_FAULT_Handler

    .section   .vector_112,code, keep
    .equ     __vector_dispatch_112, IntVectorUART1_FAULT_Handler
    .global  __vector_dispatch_112
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUART1_FAULT_Handler

IntVectorUART1_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  UART1_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUART1_FAULT_Handler
    .extern  UART1_RX_Handler

    .section   .vector_113,code, keep
    .equ     __vector_dispatch_113, IntVectorUART1_RX_Handler
    .global  __vector_dispatch_113
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUART1_RX_Handler

IntVectorUART1_RX_Handler:
    portSAVE_CONTEXT
    la    s6,  UART1_RX_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUART1_RX_Handler
    .extern  UART1_TX_Handler

    .section   .vector_114,code, keep
    .equ     __vector_dispatch_114, IntVectorUART1_TX_Handler
    .global  __vector_dispatch_114
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUART1_TX_Handler

IntVectorUART1_TX_Handler:
    portSAVE_CONTEXT
    la    s6,  UART1_TX_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUART1_TX_Handler
    .extern  CHANGE_NOTICE_J_Handler

    .section   .vector_126,code, keep
    .equ     __vector_dispatch_126, IntVectorCHANGE_NOTICE_J_Handler
    .global  __vector_dispatch_126
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorCHANGE_NOTICE_J_Handler

IntVectorCHANGE_NOTICE_J_Handler:
    portSAVE_CONTEXT
    la    s6,  CHANGE_NOTICE_J_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorCHANGE_NOTICE_J_Handler
    .extern  USB_Handler

    .section   .vector_132,code, keep
    .equ     __vector_dispatch_132, IntVectorUSB_Handler
    .global  __vector_dispatch_132
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUSB_Handler

IntVectorUSB_Handler:
    portSAVE_CONTEXT
    la    s6,  USB_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUSB_Handler
    .extern  USB_DMA_Handler

    .section   .vector_133,code, keep
    .equ     __vector_dispatch_133, IntVectorUSB_DMA_Handler
    .global  __vector_dispatch_133
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUSB_DMA_Handler

IntVectorUSB_DMA_Handler:
    portSAVE_CONTEXT
    la    s6,  USB_DMA_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUSB_DMA_Handler
    .extern  DMA0_Handler

    .section   .vector_134,code, keep
    .equ     __vector_dispatch_134, IntVectorDMA0_Handler
    .global  __vector_dispatch_134
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA0_Handler

IntVectorDMA0_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA0_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA0_Handler
    .extern  DMA1_Handler

    .section   .vector_135,code, keep
    .equ     __vector_dispatch_135, IntVectorDMA1_Handler
    .global  __vector_dispatch_135
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA1_Handler

IntVectorDMA1_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA1_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA1_Handler
    .extern  DMA2_Handler

    .section   .vector_136,code, keep
    .equ     __vector_dispatch_136, IntVectorDMA2_Handler
    .global  __vector_dispatch_136
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA2_Handler

IntVectorDMA2_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA2_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA2_Handler
    .extern  DMA3_Handler

    .section   .vector_137,code, keep
    .equ     __vector_dispatch_137, IntVectorDMA3_Handler
    .global  __vector_dispatch_137
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA3_Handler

IntVectorDMA3_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA3_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA3_Handler
    .extern  DMA4_Handler

    .section   .vector_138,code, keep
    .equ     __vector_dispatch_138, IntVectorDMA4_Handler
    .global  __vector_dispatch_138
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA4_Handler

IntVectorDMA4_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA4_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA4_Handler
    .extern  DMA5_Handler

    .section   .vector_139,code, keep
    .equ     __vector_dispatch_139, IntVectorDMA5_Handler
    .global  __vector_dispatch_139
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA5_Handler

IntVectorDMA5_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA5_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA5_Handler
    .extern  DMA6_Handler

    .section   .vector_140,code, keep
    .equ     __vector_dispatch_140, IntVectorDMA6_Handler
    .global  __vector_dispatch_140
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA6_Handler

IntVectorDMA6_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA6_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA6_Handler
    .extern  DMA7_Handler

    .section   .vector_141,code, keep
    .equ     __vector_dispatch_141, IntVectorDMA7_Handler
    .global  __vector_dispatch_141
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorDMA7_Handler

IntVectorDMA7_Handler:
    portSAVE_CONTEXT
    la    s6,  DMA7_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorDMA7_Handler
    .extern  SPI2_FAULT_Handler

    .section   .vector_142,code, keep
    .equ     __vector_dispatch_142, IntVectorSPI2_FAULT_Handler
    .global  __vector_dispatch_142
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorSPI2_FAULT_Handler

IntVectorSPI2_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  SPI2_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorSPI2_FAULT_Handler
    .extern  SPI3_FAULT_Handler

    .section   .vector_154,code, keep
    .equ     __vector_dispatch_154, IntVectorSPI3_FAULT_Handler
    .global  __vector_dispatch_154
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorSPI3_FAULT_Handler

IntVectorSPI3_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  SPI3_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorSPI3_FAULT_Handler
    .extern  UART3_FAULT_Handler

    .section   .vector_157,code, keep
    .equ     __vector_dispatch_157, IntVectorUART3_FAULT_Handler
    .global  __vector_dispatch_157
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorUART3_FAULT_Handler

IntVectorUART3_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  UART3_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorUART3_FAULT_Handler
    .extern  SPI4_FAULT_Handler

    .section   .vector_163,code, keep
    .equ     __vector_dispatch_163, IntVectorSPI4_FAULT_Handler
    .global  __vector_dispatch_163
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorSPI4_FAULT_Handler

IntVectorSPI4_FAULT_Handler:
    portSAVE_CONTEXT
    la    s6,  SPI4_FAULT_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorSPI4_FAULT_Handler
    .extern  SDHC_Handler

    .section   .vector_191,code, keep
    .equ     __vector_dispatch_191, IntVectorSDHC_Handler
    .global  __vector_dispatch_191
    .set     nomicromips
    .set     noreorder
    .set     nomips16
    .set     noat
    .ent  IntVectorSDHC_Handler

IntVectorSDHC_Handler:
    portSAVE_CONTEXT
    la    s6,  SDHC_Handler
    jalr  s6
    nop
    portRESTORE_CONTEXT
    .end   IntVectorSDHC_Handler

