/*******************************************************************************
  EVIC PLIB Implementation

  Company:
    Microchip Technology Inc.

  File Name:
    plib_evic.c

  Summary:
    EVIC PLIB Source File

  Description:
    None

*******************************************************************************/

// DOM-IGNORE-BEGIN
/*******************************************************************************
* Copyright (C) 2019 Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
*******************************************************************************/
// DOM-IGNORE-END

#include "device.h"
#include "plib_evic.h"


// *****************************************************************************
// *****************************************************************************
// Section: IRQ Implementation
// *****************************************************************************
// *****************************************************************************

void EVIC_Initialize( void )
{
    INTCONSET = _INTCON_MVEC_MASK;

    /* Set up priority and subpriority of enabled interrupts */
    IPC0SET = 0x4 | 0x0;  /* CORE_TIMER:  Priority 1 / Subpriority 0 */
    IPC2SET = 0xc00 | 0x0;  /* TIMER_2:  Priority 3 / Subpriority 0 */
    IPC6SET = 0x4 | 0x0;  /* TIMER_5:  Priority 1 / Subpriority 0 */
    IPC27SET = 0x1000 | 0x0;  /* SPI1_FAULT:  Priority 4 / Subpriority 0 */
    IPC28SET = 0xc | 0x0;  /* UART1_FAULT:  Priority 3 / Subpriority 0 */
    IPC28SET = 0xc00 | 0x0;  /* UART1_RX:  Priority 3 / Subpriority 0 */
    IPC28SET = 0xc0000 | 0x0;  /* UART1_TX:  Priority 3 / Subpriority 0 */
    IPC31SET = 0x40000 | 0x0;  /* CHANGE_NOTICE_J:  Priority 1 / Subpriority 0 */
    IPC33SET = 0x4 | 0x0;  /* USB:  Priority 1 / Subpriority 0 */
    IPC33SET = 0x400 | 0x0;  /* USB_DMA:  Priority 1 / Subpriority 0 */
    IPC33SET = 0x140000 | 0x0;  /* DMA0:  Priority 5 / Subpriority 0 */
    IPC33SET = 0x14000000 | 0x0;  /* DMA1:  Priority 5 / Subpriority 0 */
    IPC34SET = 0x14 | 0x0;  /* DMA2:  Priority 5 / Subpriority 0 */
    IPC34SET = 0x1400 | 0x0;  /* DMA3:  Priority 5 / Subpriority 0 */
    IPC34SET = 0x140000 | 0x0;  /* DMA4:  Priority 5 / Subpriority 0 */
    IPC34SET = 0x14000000 | 0x0;  /* DMA5:  Priority 5 / Subpriority 0 */
    IPC35SET = 0x14 | 0x0;  /* DMA6:  Priority 5 / Subpriority 0 */
    IPC35SET = 0x1400 | 0x0;  /* DMA7:  Priority 5 / Subpriority 0 */
    IPC35SET = 0x100000 | 0x0;  /* SPI2_FAULT:  Priority 4 / Subpriority 0 */
    IPC38SET = 0x100000 | 0x0;  /* SPI3_FAULT:  Priority 4 / Subpriority 0 */
    IPC39SET = 0x400 | 0x0;  /* UART3_FAULT:  Priority 1 / Subpriority 0 */
    IPC40SET = 0x10000000 | 0x0;  /* SPI4_FAULT:  Priority 4 / Subpriority 0 */
    IPC47SET = 0x10000000 | 0x0;  /* SDHC:  Priority 4 / Subpriority 0 */


}

void EVIC_SourceEnable( INT_SOURCE source )
{
    volatile uint32_t *IECx = (volatile uint32_t *) (&IEC0 + ((0x10 * (source / 32)) / 4));
    volatile uint32_t *IECxSET = (volatile uint32_t *)(IECx + 2);

    *IECxSET = 1 << (source & 0x1f);
}

void EVIC_SourceDisable( INT_SOURCE source )
{
    volatile uint32_t *IECx = (volatile uint32_t *) (&IEC0 + ((0x10 * (source / 32)) / 4));
    volatile uint32_t *IECxCLR = (volatile uint32_t *)(IECx + 1);

    *IECxCLR = 1 << (source & 0x1f);
}

bool EVIC_SourceIsEnabled( INT_SOURCE source )
{
    volatile uint32_t *IECx = (volatile uint32_t *) (&IEC0 + ((0x10 * (source / 32)) / 4));

    return (bool)((*IECx >> (source & 0x1f)) & 0x01);
}

bool EVIC_SourceStatusGet( INT_SOURCE source )
{
    volatile uint32_t *IFSx = (volatile uint32_t *)(&IFS0 + ((0x10 * (source / 32)) / 4));

    return (bool)((*IFSx >> (source & 0x1f)) & 0x1);
}

void EVIC_SourceStatusSet( INT_SOURCE source )
{
    volatile uint32_t *IFSx = (volatile uint32_t *) (&IFS0 + ((0x10 * (source / 32)) / 4));
    volatile uint32_t *IFSxSET = (volatile uint32_t *)(IFSx + 2);

    *IFSxSET = 1 << (source & 0x1f);
}

void EVIC_SourceStatusClear( INT_SOURCE source )
{
    volatile uint32_t *IFSx = (volatile uint32_t *) (&IFS0 + ((0x10 * (source / 32)) / 4));
    volatile uint32_t *IFSxCLR = (volatile uint32_t *)(IFSx + 1);

    *IFSxCLR = 1 << (source & 0x1f);
}

void EVIC_INT_Enable( void )
{
    __builtin_enable_interrupts();
}

bool EVIC_INT_Disable( void )
{
    uint32_t processorStatus;

    /* Save the processor status and then Disable the global interrupt */
    processorStatus = ( uint32_t )__builtin_disable_interrupts();

    /* return the interrupt status */
    return (bool)(processorStatus & 0x01);
}

void EVIC_INT_Restore( bool state )
{
    if (state)
    {
        /* restore the state of CP0 Status register before the disable occurred */
        __builtin_enable_interrupts();
    }
}


/* End of file */