/*******************************************************************************
 System Tasks File

  File Name:
    tasks.c

  Summary:
    This file contains source code necessary to maintain system's polled tasks.

  Description:
    This file contains source code necessary to maintain system's polled tasks.
    It implements the "SYS_Tasks" function that calls the individual "Tasks"
    functions for all polled MPLAB Harmony modules in the system.

  Remarks:
    This file requires access to the systemObjects global data structure that
    contains the object handles to all MPLAB Harmony module objects executing
    polled in the system.  These handles are passed into the individual module
    "Tasks" functions to identify the instance of the module to maintain.
 *******************************************************************************/

// DOM-IGNORE-BEGIN
/*******************************************************************************
* Copyright (C) 2018 Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *******************************************************************************/
// DOM-IGNORE-END

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "configuration.h"
#include "definitions.h"


// *****************************************************************************
// *****************************************************************************
// Section: RTOS "Tasks" Routine
// *****************************************************************************
// *****************************************************************************
void _USB_DEVICE_Tasks(  void *pvParameters  )
{
    while(1)
    {
        IO_12_Set();
		/* USB Device layer tasks routine */
        USB_DEVICE_Tasks(sysObj.usbDevObject0);
        IO_12_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}

void _USB_HOST_Tasks(  void *pvParameters  )
{
    while(1)
    {
        IO_11_Set();
		/* USB Host layer tasks routine */ 
        USB_HOST_Tasks(sysObj.usbHostObject0);
        IO_11_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}

/* Handle for the APP_Tasks. */
TaskHandle_t xAPP_Tasks;

void _APP_Tasks(  void *pvParameters  )
{   
    while(1)
    {
        //IO_0_Set();
        APP_Tasks();
        //IO_0_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
        
    }
}
/* Handle for the APP_USER_INPUT_Tasks. */
TaskHandle_t xAPP_USER_INPUT_Tasks;

void _APP_USER_INPUT_Tasks(  void *pvParameters  )
{   
    while(1)
    {
        //IO_1_Set();
        APP_USER_INPUT_Tasks();
        //IO_1_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}
/* Handle for the APP_SD_TASKS_Tasks. */
TaskHandle_t xAPP_SD_TASKS_Tasks;

void _APP_SD_TASKS_Tasks(  void *pvParameters  )
{   
    while(1)
    {
        IO_2_Set();
        APP_SD_TASKS_Tasks();
        IO_2_Clear();
        //vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}
/* Handle for the APP_COMMUNICATION_TASK_Tasks. */
TaskHandle_t xAPP_COMMUNICATION_TASK_Tasks;

void _APP_COMMUNICATION_TASK_Tasks(  void *pvParameters  )
{   
    while(1)
    {
        //IO_3_Set();
        APP_COMMUNICATION_TASK_Tasks();
        //IO_3_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}
/* Handle for the APP_USB_Tasks. */
TaskHandle_t xAPP_USB_Tasks;

void _APP_USB_Tasks(  void *pvParameters  )
{   
    while(1)
    {
        //IO_4_Set();
        APP_USB_Tasks();
        //IO_4_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}
/* Handle for the APP_CNN_DETECTION_Tasks. */
TaskHandle_t xAPP_CNN_DETECTION_Tasks;

void _APP_CNN_DETECTION_Tasks(  void *pvParameters  )
{   
    portTASK_USES_FLOATING_POINT();
    
    while(1)
    {
        //IO_5_Set();
        APP_CNN_DETECTION_Tasks();
        //IO_5_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}

void _DRV_USBHS_Tasks(  void *pvParameters  )
{
    while(1)
    {
		/* USB FS Driver Task Routine */
        //IO_6_Set();
        DRV_USBHS_Tasks(sysObj.drvUSBHSObject);
        //IO_6_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
    }
}


void _SYS_FS_Tasks(  void *pvParameters  )
{
    while(1)
    {
        //IO_7_Set();
        SYS_FS_Tasks();
        //IO_7_Clear();
        vTaskDelay(10 / portTICK_PERIOD_MS);
        
    }
}


void _DRV_SDMMC0_Tasks(  void *pvParameters  )
{
    while(1)
    {
        //IO_8_Set();
        DRV_SDMMC_Tasks(sysObj.drvSDMMC0);
        //IO_8_Clear();
        vTaskDelay(DRV_SDMMC_RTOS_DELAY_IDX0 / portTICK_PERIOD_MS);        
    }
}




// *****************************************************************************
// *****************************************************************************
// Section: System "Tasks" Routine
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void SYS_Tasks ( void )

  Remarks:
    See prototype in system/common/sys_module.h.
*/
void SYS_Tasks ( void )
{
    /* Maintain system services */
    
    xTaskCreate( _SYS_FS_Tasks,
        "SYS_FS_TASKS",
        SYS_FS_STACK_SIZE,
        (void*)NULL,
        SYS_FS_PRIORITY,
        (TaskHandle_t*)NULL
    );

    xTaskCreate( _DRV_SDMMC0_Tasks,
        "DRV_SDMMC0_Tasks",
        DRV_SDMMC_STACK_SIZE_IDX0,
        (void*)NULL,
        DRV_SDMMC_PRIORITY_IDX0,
        (TaskHandle_t*)NULL
    );





    /* Maintain Device Drivers */
    

    /* Maintain Middleware & Other Libraries */
        /* Create OS Thread for USB_DEVICE_Tasks. */
    xTaskCreate( _USB_DEVICE_Tasks,
        "USB_DEVICE_TASKS",
        1024,
        (void*)NULL,
        5,
        (TaskHandle_t*)NULL
    );

    /* Create OS Thread for USB_HOST_Tasks. */
    xTaskCreate( _USB_HOST_Tasks,
        "USB_HOST_TASKS",
        1024,
        (void*)NULL,
        5,
        (TaskHandle_t*)NULL
    );

	/* Create OS Thread for USB Driver Tasks. */
    xTaskCreate( _DRV_USBHS_Tasks,
        "DRV_USBHS_TASKS",
        1024,
        (void*)NULL,
        4,
        (TaskHandle_t*)NULL
    );



    /* Maintain the application's state machine. */
        /* Create OS Thread for APP_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_Tasks,
                "APP_Tasks",
                2048,
                NULL,
                2,
                &xAPP_Tasks);

    /* Create OS Thread for APP_USER_INPUT_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_USER_INPUT_Tasks,
                "APP_USER_INPUT_Tasks",
                256,
                NULL,
                2,
                &xAPP_USER_INPUT_Tasks);

    /* Create OS Thread for APP_SD_TASKS_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_SD_TASKS_Tasks,
                "APP_SD_TASKS_Tasks",
                8192,
                NULL,
                2,
                &xAPP_SD_TASKS_Tasks);

    /* Create OS Thread for APP_COMMUNICATION_TASK_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_COMMUNICATION_TASK_Tasks,
                "APP_COMMUNICATION_TASK_Tasks",
                2048,
                NULL,
                2,
                &xAPP_COMMUNICATION_TASK_Tasks);

    /* Create OS Thread for APP_USB_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_USB_Tasks,
                "APP_USB_Tasks",
                1024,
                NULL,
                2,
                &xAPP_USB_Tasks);

    /* Create OS Thread for APP_CNN_DETECTION_Tasks. */
    xTaskCreate((TaskFunction_t) _APP_CNN_DETECTION_Tasks,
                "APP_CNN_DETECTION_Tasks",
                4096,
                NULL,
                2,
                &xAPP_CNN_DETECTION_Tasks);




    /* Start RTOS Scheduler. */
    
     /**********************************************************************
     * Create all Threads for APP Tasks before starting FreeRTOS Scheduler *
     ***********************************************************************/
    vTaskStartScheduler(); /* This function never returns. */

}

/*******************************************************************************
 End of File
 */

