/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes

/* Cache Coherency Configuration Options (KSEG0) */
#define UNCACHED 0x02   // uncached
#define WB_WA 0x03      // write-back, write allocate
#define WT_WA 0x01      // write-through, write allocate
#define WT_NWA 0x00     // write-through, no write allocate
void set_cache_policy(int cc)
{
    unsigned int cp0;
    cp0 = _mfc0(16, 0); // read the cp0 config register
    cp0 &= ~0x03;       // clear the K0 field
    cp0 |= cc;          // update K0 with the new value
    _mtc0(16, 0, cp0);  // write the cp0 config register
}

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************

int main ( void )
{
    /* Initialize all modules */
    SYS_Initialize ( NULL );


    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        SYS_Tasks ( );
    }

    /* Execution should not come here during normal operation */

    return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

