#ifndef USTV_FILTRES
#define USTV_FILTRES

extern double ACCELRealSamplingFreq;
/*******************************************************************************
 * INCLUDES
 ******************************************************************************/
#include "Define.h"
#include <stdbool.h>

#define USE_FILTER

#define AXE_X 0
#define AXE_Y 1
#define AXE_Z 2

#ifdef USE_Q16
#include <libq.h>
#define NULLACCU ((_Q16)0)
#define _Q16_CONST_0_5F 32768
#define _Q16_CONST_1 65536
#define _Q16_CONST_1_1 72089
#define _Q16_CONST_1_5 98304
#define _Q16_CONST_2 131072
#define _Q16_CONST_4 262144
#define _Q16_CONST_16 1048576
#define _Q16_CONST_10 655360
#define _Q16_CONST_100 6553600
#define _Q16_CONST_1000 0x3E80000
#define _Q16_CONST_0_1G_MpS 64291               //0.1G en M/s2 == 0.981M/s2
#define _Q16_CONST_0_01G_MpS 6429               //0.01G en M/s2 == 0.0981M/s2
#define _Q16_CONST_0_01 6429
#define _Q16_CONST_0_005 3214

#endif
extern unsigned int nbSerieDone_X;
extern unsigned int nbSerieDone_Y;
extern unsigned int nbSerieDone_Z;


/*******************************************************************************
 * TYPEDEF STRUCTURES
 ******************************************************************************/
typedef enum { Waiting, TriggeredHigh, TriggeredLow, TriggeredHighAndLow} TrigState;

/*
typedef struct FiltreOrdre1_struct {
    double w0;
    double ts;
    double c;
    double Q;

    double n_0;
    double n_1;
    double d_0;
    double d_1;

    double e_0;
    double e_1;
    double s_0;
    double s_1;
} FiltreOrdre1;
*/
#ifdef USE_Q16
typedef struct FiltreOrdre1_struct {
    _Q16 w0;
    _Q16 ts;
    _Q16 c;
    _Q16 Q;

    _Q16 n_0;
    _Q16 n_1;
    _Q16 d_0;
    _Q16 _d_0;                      //Correspond a 1/d0
    _Q16 d_1;

    _Q16 e_1;
    _Q16 s_0;
    _Q16 s_1;

    unsigned char initOutputMode;
} FiltreOrdre1;
#endif

typedef struct FiltreOrdre1dbl_struct {
    double w0;
    double ts;
    double c;
    double Q;

    double n_0;
    double n_1;
    double d_0;
    double _d_0;                      //Correspond a 1/d0
    double d_1;

    double e_1;
    double s_0;
    double s_1;

    unsigned char initOutputMode;
} FiltreOrdre1dbl;


typedef struct FiltreOrdre4dbl_struct {
    double e_4;
    double e_3;
    double e_2;
    double e_1;

    double s_4;
    double s_3;
    double s_2;
    double s_1;
    double s_0;
} FiltreOrdre4dbl;

//typedef struct FiltreOrdre8dbl_struct {
//    double e_8;
//    double e_7;
//    double e_6;
//    double e_5;
//    double e_4;
//    double e_3;
//    double e_2;
//    double e_1;
//
//    double s_8;
//    double s_7;
//    double s_6;
//    double s_5;
//    double s_4;
//    double s_3;
//    double s_2;
//    double s_1;
//    double s_0;
//} FiltreOrdre8dbl;
#ifdef USE_Q16
typedef struct FiltreOrdre2_struct {
    _Q16 w0;          //Pulsation du filtre
    _Q16 ts;          //Sample time
    _Q16 c;
    _Q16 Q;

    _Q16 n_0;
    _Q16 n_1;
    _Q16 n_2;
    _Q16 _d_0;          //Constante correspondant a 1/d0;
    _Q16 d_1;
    _Q16 d_2;

    _Q16 e_1;         //entree n-1
    _Q16 e_2;         //entree n-2
    _Q16 s_0;         //sortie
    _Q16 s_1;         //sortie n-1
    _Q16 s_2;         //sortie n-2
}FiltreOrdre2;
#endif
typedef struct FiltreOrdre2dbl_struct {
    double w0;          //Pulsation du filtre
    double ts;          //Sample time
    double c;
    double Q;

    double n_0;
    double n_1;
    double n_2;
    double d_0;
    double d_1;
    double d_2;

    double e_1;         //entree n-1
    double e_2;         //entree n-2
    double s_0;         //sortie
    double s_1;         //sortie n-1
    double s_2;         //sortie n-2
}FiltreOrdre2dbl;

#ifdef USE_Q16
typedef struct FiltreMinMax_struct {
    FiltreOrdre2 *filtreMin;          //
    FiltreOrdre2 *filtreMax;          //
    double aMaxMoy;
    double aMinMoy;
    double aMax;
    double aMin;
    BOOL flagCroissant;
    BOOL flagDecroissant;
    TrigState trigState;
    TrigState trigStateStart;
}FiltreMinMaxOrdre2;

typedef struct FiltreMinMax1_struct {
    FiltreOrdre1 *filtreMin;          //
    FiltreOrdre1 *filtreMax;          //
    unsigned long timeStampLastTriggerUp;
    unsigned long timeStampLastTriggerDown;
    _Q16 aMax;
    _Q16 aMin;
    BOOL flagCroissant;
    BOOL flagDecroissant;
    TrigState trigState;
    TrigState trigStateStart;
    long deadZoneDelay;
    _Q16 amplitudeMin;
}FiltreMinMaxOrdre1;
#endif
typedef struct FiltreMinMax1dbl_struct {
    FiltreOrdre1dbl *filtreMin;          //
    FiltreOrdre1dbl *filtreMax;          //
    double aMaxMoy;
    double aMinMoy;
    double aMax;
    double aMin;
    bool flagCroissant;
    bool flagDecroissant;
    TrigState trigState;
    TrigState trigStateStart;
}FiltreMinMaxOrdre1dbl;

#ifdef USE_Q16
typedef struct FiltreNbRep_struct {
    FiltreMinMaxOrdre1 *extremumLocal;
    unsigned long timeStampMinMax;
    unsigned long timeStampMinMaxT_1;
    int nbDeRepCumulees;
    _Q16 amplitude;
    _Q16 topValueUp;
    _Q16 topValueDown;
    _Q16 topValueUpT_1;
    _Q16 topValueDownT_1;
    unsigned int periodeRep;
    char flag_axe;
}FiltreNbRep;


typedef struct _Q16Integrateur_struct {
    _Q16 s_0;
    _Q16 e_1;
    _Q16 _d_0;
} _Q16Integrateur;
#endif

typedef struct Integrateur_struct {
    double s_0;
    double e_1;
    double _d_0;
    double fech;
} Integrateur;

typedef struct Derivateur_struct {
    double e_1;
    double fech;
} Derivateur;

typedef struct Threshold_struct {
    double Value;
    bool threshold_t_1;
}Threshold;

#ifdef USE_Q16
typedef struct _Q16_IdleDetector_struct
{
    _Q16 idleAccelRefValue;
    unsigned char flagAccelIdle;
    unsigned char flagAccelIdleChanged;
    unsigned long idleStartTime;
    _Q16 accelIdleSensitivity;
    unsigned int accelIdleMinTime;
}_Q16IdleDetector;

#endif
#ifdef USE_FILTER
    /*******************************************************************************
     * VARIABLES
     ******************************************************************************/

    /*******************************************************************************
     * PROTOTYPES
     ******************************************************************************/
    void InitFiltres();
    #ifdef USE_Q16
        _Q16 FiltreOrdre1TpsReel(FiltreOrdre1 * filtre, _Q16 e_0);
    #endif    
    double FiltreOrdre1TpsReeldbl(FiltreOrdre1dbl * filtre, double e_0);
    #ifdef USE_Q16
        _Q16 FiltreOrdre1TpsReelScaled(FiltreOrdre1 * filtre, _Q16 e_0, _Q16 scale);
        _Q16 FiltreOrdre2TpsReel(FiltreOrdre2 * filtre, _Q16 e_0);
    #endif
    double FiltreOrdre2TpsReeldbl(FiltreOrdre2dbl * filtre, double e_0);
    double Filtre_Specific_BP4_Tchebytchev_8Hz_20Hz_Ech125Hz_TpsReel(FiltreOrdre4dbl * filtre, double e_0);
    double Filtre_Specific_BP4_Tchebytchev_8Hz_20Hz_Ech250Hz_TpsReel(FiltreOrdre4dbl * filtre, double e_0);

    #ifdef USE_Q16
        void FiltrePasseHautButterworthOrdre1Init(FiltreOrdre1 * filtre, double fEch, double f0);
        void FiltrePasseHautButterworthOrdre1OutputInit(FiltreOrdre1 * filtre);
        void FiltrePasseHautButterworthOrdre1SetFrequence(FiltreOrdre1 * filtre, double freqEch, double freqCoupure);
        void FiltrePasseBasButterworthOrdre1Init(FiltreOrdre1 * filtre, double fEch, double f0);
        void FiltrePasseBasButterworthOrdre1OutputInit(FiltreOrdre1 * filtre);
    #endif
    void FiltrePasseBasButterworthOrdre1Initdbl(FiltreOrdre1dbl * filtre, double freqEch, double freqCoupure);
    void FiltrePasseBasButterworthOrdre1OutputInitdbl(FiltreOrdre1dbl * filtre);
    #ifdef USE_Q16
        void FiltrePasseBasButterworthOrdre1SetFrequence(FiltreOrdre1 * filtre, double freqEch, double freqCoupure);
        void FiltrePasseHautButterworthOrdre2Init(FiltreOrdre2 * filtre, double fEch, double f0);
        void FiltrePasseHautButterworthOrdre2SetFrequence(FiltreOrdre2 * filtre, double freqEch, double freqCoupure);
        void FiltrePasseBasButterworthOrdre2Init(FiltreOrdre2 * filtre, double fEch, double f0);
        void FiltrePasseBasButterworthOrdre2SetFrequence(FiltreOrdre2 * filtre, double freqEch, double freqCoupure);
    #endif
    
    void FiltrePasseHautButterworthOrdre1Initdbl(FiltreOrdre1dbl * filtre, double freqEch, double freqCoupure);
    void FiltrePasseBasButterworthOrdre1Initdbl(FiltreOrdre1dbl * filtre, double fEch, double freqCoupure);
    void FiltrePasseHautButterworthOrdre2Initdbl(FiltreOrdre2dbl * filtre, double fEch, double freqCoupure);
    void FiltrePasseBasButterworthOrdre2Initdbl(FiltreOrdre2dbl * filtre, double fEch, double freqCoupure);
    void FiltreNotchOrdre2Initdbl(FiltreOrdre2dbl * filtre, double freqEch, double freqNotch);
    void FiltrePasseBandeButterworthOrdre4Initdbl(FiltreOrdre4dbl * filtre);
    //void FiltrePasseBandeButterworthOrdre8Initdbl(FiltreOrdre8dbl * filtre);

    #ifdef USE_Q16
        void FiltreOrdre1SetOutput(FiltreOrdre1 * filtre, double value);
        void FiltreOrdre2SetOutput(FiltreOrdre2 * filtre, double value);
    #endif

    void SetFrequencePasseBasOrdre1dbl(FiltreOrdre1dbl * filtre, double freqEch, double freqCoupure);
    void SetFrequencePasseHautOrdre2dbl(FiltreOrdre2dbl * filtre, double freqEch, double freqCoupure);
    void SetFrequencePasseBasOrdre2dbl(FiltreOrdre2dbl * filtre, double freqEch, double freqCoupure);
    #ifdef USE_Q16
        _Q16 _Q16Integrate(_Q16Integrateur* filtre, _Q16 e_0);
        void _Q16IntegrateurInit(_Q16Integrateur * filtre, double fech);
        void _Q16IntegrateurReset(_Q16Integrateur * filtre);
    #endif
    double Integrate(Integrateur* filtre, double e_0);
    void IntegrateurInit(Integrateur * filtre, double fech);

    double Derivate(Derivateur * filtre, double e_0);
    void DerivateurInit(Derivateur * filtre, double freqEch);

    #ifdef USE_Q16
        void CalculCroissantDecroissant(FiltreMinMaxOrdre2 * filtre, double amplitude);
        void MinMaxSetOuput(FiltreMinMaxOrdre2 * filtre, double value);
    #endif
    #ifdef USE_Q16
        void FiltreMinMaxOrdre1Init(FiltreMinMaxOrdre1 * filtre, double freqEch, double f0, long deadZoneDelay, double minTriggerValue);
    #endif
    void FiltreMinMaxOrdre1Initdbl(FiltreMinMaxOrdre1dbl * filtre, double freqEch, double f0);
    void FiltreMinMaxOrdre1Process(FiltreMinMaxOrdre1dbl * filtre, double value);
    void FiltreMinMaxOrdre1Processdbl(FiltreMinMaxOrdre1dbl * filtre, double value);
    #ifdef USE_Q16
        unsigned char FiltreMinMaxOrdre1CalculCroissant(FiltreMinMaxOrdre1 * filtre, _Q16 vit, _Q16 amplitudeMin);
        unsigned char FiltreMinMaxOrdre1CalculDecroissant(FiltreMinMaxOrdre1 * filtre, _Q16 vit, _Q16 amplitudeMin);
    #endif
    void FiltreMinMaxOrdre1CalculCroissantdbl(FiltreMinMaxOrdre1dbl * filtre, double vit, double amplitudeMin);
    void FiltreMinMaxOrdre1CalculDecroissantdbl(FiltreMinMaxOrdre1dbl * filtre, double vit, double amplitudeMin);
    #ifdef USE_Q16
        void FiltreMinMaxOrdre1ResetTrig(FiltreMinMaxOrdre1 * filtre);
    #endif
    void FiltreMinMaxOrdre1ResetTrigdbl(FiltreMinMaxOrdre1dbl * filtre);
    #ifdef USE_Q16
    void FiltreMinMaxOrdre1Reset(FiltreMinMaxOrdre1 * filtre);
    void FiltreMinMaxOrdre2Process(FiltreMinMaxOrdre2 * filtre, double value);
    void FiltreMinMaxOrdre2Init(FiltreMinMaxOrdre2 * filtre, double freqEch, double f0);

    void FiltreNbRepInit(FiltreNbRep * filtre, FiltreMinMaxOrdre1 * filtreMinMax,
            FiltreOrdre1 * filtreLP1Min, FiltreOrdre1 * filtreLP1Max,
            double freqCoupure, double freqEch, long deadZoneDelay, double minTriggerValue);
    void FiltreNbRepReset(FiltreNbRep * filtre);
    unsigned char FiltreNbRepProcess(FiltreNbRep * filtre, _Q16Data * value, _Q16Data * valueTopMeasure, unsigned long timeStamp);
    #endif


    int CrossDetector(double signal1);
    double Thresholddbl(double signal, Threshold *threshold);


    /*******************************************************************************
     *   Filtre Idle Detector
     ******************************************************************************/
    #ifdef USE_Q16
    void _Q16IdleDetectorProcess(_Q16IdleDetector * idleDetector, _Q16Data * accel, unsigned long timestamp);
    unsigned char _Q16IdleDetectorIsIdle(_Q16IdleDetector * idleDetector);
    unsigned char _Q16IdleDetectorStateHasChanged(_Q16IdleDetector * idleDetector);
    void _Q16IdleDetectorInit(_Q16IdleDetector * idleDetector, _Q16 sensitivity, unsigned int idleTime);
    /*
    void _Q16IdleDetector(_Q16Data *accel, double fech);
    int CrossDetector(double signal1);
    double Thresholddbl(double signal, Threshold *threshold);
    BOOL AccelIsIdle();
    BOOL AccelIdleStateHasChanged();
    */

    static inline _Q16 itoQ16(int x)
    {
      return (_Q16) ((long)x <<16);
    }

    static inline _Q16 _Q16sqrt(_Q16 x){    return _Q16power(x,_Q16_CONST_0_5F);    }

    #ifdef USE_ACCEL_RECALAGE
    _Q16DataXYZ ACCELRecaleAccel(_Q16DataXYZ accelNormalized);
    #endif
#endif

    #ifdef USE_ACCEL_FILTER
        void AccelPpFiltersInit();
        //Filtre Recalage
        void ACCELPpFiltreRecalageInit();
        void ACCELPpFiltreRecalageSetOutput(_Q16DataXYZ value);
        void ACCELPpFiltreRecalageProcess(_Q16DataXYZ accel, _Q16DataXYZ * accelRecale_out);
        void ACCELPpFiltreRecalageGetAngleParRapportVertical(_Q16 accelX_LF, _Q16 accelY_LF, _Q16 accelZ_LF, _Q16 *theta, _Q16 *phi);
        void ACCELPpFiltreRecalageSetBaseVerticale(_Q16 accelX, _Q16 accelY, _Q16 accelZ, _Q16 theta, _Q16 phi, _Q16 result[]);
        void ACCELPpGetAngleRecalage(_Q16 *thetaQ16, _Q16 *phiQ16);

        _Q16DataXYZ ACCELPpAccelRMS(_Q16DataXYZ accelRecalVertical);
        void ACCELPpAccelRMSFiltersInit();
        void ACCELPutEnergieValueToRAM(int ACCELEnergieValue);

        _Q16DataXYZ ACCELPpRepetionPosition(_Q16DataXYZ accelNormalise, _Q16DataXYZ accelRecalVertical);
        void ACCELPpConfig(BOOL useRecalage, BOOL useEnergy, BOOL usePosition);
        void ACCELPpInitFilters();
        void ACCELPpFiltreNbRepSetParameters(double freqCoupure, long deadZoneDelay, double minTriggerValue);
        void ACCELPpInitFilters_Fitness();


        //Declarations
        #ifdef USE_ACCEL_3d_FILTER
            extern FiltreNbRep ACCELPpNbRepFilter_NbRep1_X;
            extern FiltreNbRep ACCELPpNbRepFilter_NbRep1_Y;
        #endif
        extern FiltreNbRep ACCELPpNbRepFilter_NbRep1_Z;
    #endif
#endif

#ifdef USE_Q16        
_Q16DataXYZ ACCELPpEquilibreFiltre(_Q16DataXYZ accelNormalise);
void ACCELPpEquilibreProcessing( _Q16DataXYZ accelFiltree );
#endif
void ACCELPpInitFilters_Equilibre(void);
void ACCELPpFilters_EquilibreClear(void);
void SendTrameEquilibreStats(void);

#endif

