## Environment setup - first time use

Install ffmpeg

Mac - `brew install ffmpeg`
Windows - ? did not appear to be necessary

Download and install sox from https://sourceforge.net/projects/sox/
Add sox to your local path (edit .zshrc in your home directory or equivalent)

Create and activate a new Conda Environment

```
conda create -n bioac python=3.7
conda activate bioac
```

Install dependencies
`pip install -r requirements.txt`

Place `log2wav` in your path.
If you don't have the binary for your machine compile it with: `gcc log2wav.c -o log2wav`

Install soundscape_IR

```
git clone https://github.com/schonkopf/soundscape_IR.git
cd soundscape_IR
pip install -r requirements.txt
```

Place the soundscape directory in the same directory as your calling code (eg bioacoustics/processing)

## Environment setup - subsequent launches

`conda activate bioac`

## Workflow

1. Create a directory structure with the following form:
   -- Projects
   -- -- ProjectName
   -- -- -- data # project related data
   -- -- -- Plotname1
   -- -- -- -- RecordingDate1
   -- -- -- -- -- log # for original log files
   -- -- -- -- -- wav # for wav files that are converted from log
   -- -- -- -- -- lts # for Long Term Spectrum images
   -- -- -- -- -- spectrograms # for individual file spectrograms
   -- -- -- -- -- data # for other data related to the plot-date
   -- -- -- -- -- indices # for audio indices
   -- -- -- -- -- wav_lr # for low res audio files
   -- -- -- -- RecordingDate2
   ...
   -- -- -- Plotname2
   ...

The wav, wav_lr, lts, spectrograms, indices and data sub-directories will be automatically created by the utilities below if not already present

In ProjectName/data place plot_types.json. Adapt to your case.

In the utilities you will find 'root_dir' defined at the top of the code.

- Adjust this to point to the data root of the system you are on
- The root_dir can be automatically set via the environment variable GPSVR=SERVER (or LOCAL)
- Use the command line with -d to specify plot/date, and -c to specify channel

1. Convert log files wav
   Run log2wav.py

2. Create long term spectrograms
   Run lts.py

3. Create audio indices
   Run indices.py

4. Create master index of all plot/dates and display box plots
   Run indices_display.py

5. Create audio indices divided by frequency bins
   Run indices_display_2d.py

## Shell Utilities

- namechange - File rename to handle files with HIGHBLUE prefix
- change2mono - Convert 4 channel to mono (requires sox)
- log2wavfolder - run log2wav for every file in the current folder

## Random

- Cards are formatted exFAT 2048 partition size. this can't be read by a mac
